/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.service.serviceaction.repair.effectors;

import com.ibm.hwmca.fw.service.managedsystem.ServiceableElement;
import com.ibm.hwmca.fw.service.serviceaction.ServiceActionType;
import com.ibm.hwmca.fw.service.statetransition.Context;
import com.ibm.hwmca.fw.service.statetransition.Effector;
import com.ibm.hwmca.fw.service.statetransition.EffectorException;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.p.service.serviceaction.repair.effectors.PIDriveInfoCenterExchangeAndVerify;
import com.ibm.hwmca.xfw.service.SD;
import com.ibm.hwmca.xfw.service.managedsystem.fru.InfoCenterFru;
import com.ibm.hwmca.xfw.service.serviceaction.ServiceActionStateEngine;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PIDriveExchangeAndVerify
implements Effector {
    private static final String TRACE_MASKT = "XRVPDEVT";
    private static final String TRACE_MASKF = "XRVPDEVF";
    private static final String TRACE_MASKD = "XRVPDEVD";
    protected Map rulesFileMapping = null;
    protected static String TYPE_ENCLOSURE = "ENCLOSURE";
    protected static String TYPE_SPCN_FRU = "SPCN_FRU";
    protected static String TYPE_NORMAL_FRU = "NORMAL_FRU";
    protected static String TYPE_INFO_CENTER_FRU = "INFO_CENTER_FRU";
    protected static Effector INFO_CENTER_EXCHANGE_EFFECTOR = new PIDriveInfoCenterExchangeAndVerify();
    protected static Effector INFO_CENTER_INSTALL_EFFECTOR = new PIDriveInfoCenterExchangeAndVerify();
    protected static Effector INFO_CENTER_REMOVE_EFFECTOR = new PIDriveInfoCenterExchangeAndVerify();

    public PIDriveExchangeAndVerify() {
        this.init();
    }

    protected void init() {
        if (this.rulesFileMapping == null) {
            this.rulesFileMapping = new HashMap();
        }
        this.rulesFileMapping.put(ServiceActionType.MES_INSTALL_ENCLOSURE.getValue() + "|" + TYPE_ENCLOSURE, "data/service/rules/p/mesinstall/PIIOSPCN_InstallAndVerifyRules.xml");
        this.rulesFileMapping.put(ServiceActionType.MES_INSTALL_ENCLOSURE.getValue() + "|" + TYPE_INFO_CENTER_FRU, INFO_CENTER_INSTALL_EFFECTOR);
        this.rulesFileMapping.put(ServiceActionType.MES_INSTALL_FRU.getValue() + "|" + TYPE_SPCN_FRU, "data/service/rules/p/mesinstall/PIIOSPCN_InstallAndVerifyRules.xml");
        this.rulesFileMapping.put(ServiceActionType.MES_INSTALL_FRU.getValue() + "|" + TYPE_NORMAL_FRU, "data/service/rules/p/mesinstall/PIIONonSPCN_InstallAndVerifyRules.xml");
        this.rulesFileMapping.put(ServiceActionType.MES_INSTALL_FRU.getValue() + "|" + TYPE_INFO_CENTER_FRU, INFO_CENTER_INSTALL_EFFECTOR);
        this.rulesFileMapping.put(ServiceActionType.MES_REMOVE_ENCLOSURE.getValue() + "|" + TYPE_ENCLOSURE, "data/service/rules/p/mesremove/PIIOSPCN_RemoveAndVerifyRules.xml");
        this.rulesFileMapping.put(ServiceActionType.MES_REMOVE_FRU.getValue() + "|" + TYPE_INFO_CENTER_FRU, INFO_CENTER_REMOVE_EFFECTOR);
        this.rulesFileMapping.put(ServiceActionType.MES_REMOVE_FRU.getValue() + "|" + TYPE_SPCN_FRU, "data/service/rules/p/mesremove/PIIOSPCN_RemoveAndVerifyRules.xml");
        this.rulesFileMapping.put(ServiceActionType.MES_REMOVE_FRU.getValue() + "|" + TYPE_NORMAL_FRU, "data/service/rules/p/mesremove/PIIONonSPCN_RemoveAndVerifyRules.xml");
        this.rulesFileMapping.put(ServiceActionType.MES_REMOVE_FRU.getValue() + "|" + TYPE_INFO_CENTER_FRU, INFO_CENTER_REMOVE_EFFECTOR);
        this.rulesFileMapping.put(ServiceActionType.REPLACE_ENCLOSURE.getValue() + "|" + TYPE_ENCLOSURE, "data/service/rules/p/repair/PIIOSPCN_ExchangeAndVerifyRules.xml");
        this.rulesFileMapping.put(ServiceActionType.REPLACE_ENCLOSURE.getValue() + "|" + TYPE_INFO_CENTER_FRU, INFO_CENTER_EXCHANGE_EFFECTOR);
        this.rulesFileMapping.put(ServiceActionType.REPLACE_FRU.getValue() + "|" + TYPE_SPCN_FRU, "data/service/rules/p/repair/PIIOSPCN_ExchangeAndVerifyRules.xml");
        this.rulesFileMapping.put(ServiceActionType.REPLACE_FRU.getValue() + "|" + TYPE_NORMAL_FRU, "data/service/rules/p/repair/PIIONonSPCN_ExchangeAndVerifyRules.xml");
        this.rulesFileMapping.put(ServiceActionType.REPLACE_FRU.getValue() + "|" + TYPE_INFO_CENTER_FRU, INFO_CENTER_EXCHANGE_EFFECTOR);
        this.rulesFileMapping.put(ServiceActionType.REPAIR_PROBLEM.getValue() + "|" + TYPE_ENCLOSURE, "data/service/rules/p/repair/PIIOSPCN_ExchangeAndVerifyRules.xml");
        this.rulesFileMapping.put(ServiceActionType.REPAIR_PROBLEM.getValue() + "|" + TYPE_SPCN_FRU, "data/service/rules/p/repair/PIIOSPCN_ExchangeAndVerifyRules.xml");
        this.rulesFileMapping.put(ServiceActionType.REPAIR_PROBLEM.getValue() + "|" + TYPE_NORMAL_FRU, "data/service/rules/p/repair/PIIONonSPCN_ExchangeAndVerifyRules.xml");
        this.rulesFileMapping.put(ServiceActionType.REPAIR_PROBLEM.getValue() + "|" + TYPE_INFO_CENTER_FRU, INFO_CENTER_EXCHANGE_EFFECTOR);
        this.rulesFileMapping.put(ServiceActionType.POWER_OFF.getValue() + "|" + TYPE_ENCLOSURE, "data/service/rules/p/utils/PIPowerOffLocationRules.xml");
        this.rulesFileMapping.put(ServiceActionType.POWER_OFF.getValue() + "|" + TYPE_SPCN_FRU, "data/service/rules/p/utils/PIPowerOffLocationRules.xml");
        this.rulesFileMapping.put(ServiceActionType.POWER_OFF.getValue() + "|" + TYPE_NORMAL_FRU, "data/service/rules/p/utils/PIPowerOffLocationRules.xml");
        this.rulesFileMapping.put(ServiceActionType.POWER_OFF.getValue() + "|" + TYPE_INFO_CENTER_FRU, INFO_CENTER_EXCHANGE_EFFECTOR);
        this.rulesFileMapping.put(ServiceActionType.POWER_ON.getValue() + "|" + TYPE_ENCLOSURE, "data/service/rules/p/utils/PIPowerOnLocationRules.xml");
        this.rulesFileMapping.put(ServiceActionType.POWER_ON.getValue() + "|" + TYPE_SPCN_FRU, "data/service/rules/p/utils/PIPowerOnLocationRules.xml");
        this.rulesFileMapping.put(ServiceActionType.POWER_ON.getValue() + "|" + TYPE_NORMAL_FRU, "data/service/rules/p/utils/PIPowerOnLocationRules.xml");
        this.rulesFileMapping.put(ServiceActionType.POWER_ON.getValue() + "|" + TYPE_INFO_CENTER_FRU, INFO_CENTER_EXCHANGE_EFFECTOR);
    }

    public void fire(Context context) throws EffectorException {
        Trace.trace(TRACE_MASKT, "-> PIDriveExchangeAndVerify.fire");
        try {
            String overallStatus;
            boolean partialGroupProcessed;
            Map userData = context.getUserData();
            List fruList = (List)userData.get("SELECTED_FRUS");
            Iterator it = fruList.iterator();
            String saType = (String)userData.get("rvType");
            String fruType = TYPE_NORMAL_FRU;
            if (saType.equals(ServiceActionType.REPLACE_ENCLOSURE.getValue()) || saType.equals(ServiceActionType.MES_INSTALL_ENCLOSURE.getValue()) || saType.equals(ServiceActionType.MES_REMOVE_ENCLOSURE.getValue())) {
                fruType = TYPE_ENCLOSURE;
            } else {
                while (it.hasNext()) {
                    ServiceableElement se = (ServiceableElement)it.next();
                    Trace.trace(TRACE_MASKD, "PIDriveExchangeAndVerify.fire - walking selecteed FRU list: " + se);
                    Trace.trace(TRACE_MASKD, "PIDriveExchangeAndVerify.fire - se instanceof InfoCenterFru: " + Boolean.valueOf(se instanceof InfoCenterFru));
                    if (se instanceof InfoCenterFru) {
                        Trace.trace(TRACE_MASKD, "PIDriveExchangeAndVerify.fire - found and infocenter FRU");
                        fruType = TYPE_INFO_CENTER_FRU;
                        break;
                    }
                    String cur = (String)se.getProperty("CONFIG_UPDATE_REQUIRED");
                    if (cur == null || !cur.toUpperCase().equals("TRUE") && !cur.toUpperCase().equals("YES")) continue;
                    Trace.trace(TRACE_MASKD, "PIDriveExchangeAndVerify.fire - found an SPCN FRU");
                    fruType = TYPE_SPCN_FRU;
                    break;
                }
            }
            Object target = this.rulesFileMapping.get(saType + "|" + fruType);
            if (target == null) {
                Trace.trace(TRACE_MASKD, "<-! PIDriveExchangeAndVerify.fire - unmapped type->action found: " + saType + "|" + fruType);
                throw new EffectorException("unmapped type->action found: " + saType + "|" + fruType);
            }
            if (target instanceof String) {
                File file = new File(System.getProperty("CONSOLE_PATH") + "/" + (String)target);
                ServiceActionStateEngine.fire(file, context, context.getUserData());
            } else {
                ((Effector)target).fire(context);
            }
            boolean bl = partialGroupProcessed = userData.get("PARTIAL_FRU_GROUP_SELECTED") == null ? false : (Boolean)userData.get("PARTIAL_FRU_GROUP_SELECTED");
            if (!saType.equals(ServiceActionType.REPAIR_PROBLEM.getValue()) && context.getVariable(SD.OVERALL_STATUS_VARIABLE).getValue().equals(SD.CONTINUE)) {
                context.getVariable(SD.OVERALL_STATUS_VARIABLE).setValue(SD.SWITCH_FRUS);
            } else if (partialGroupProcessed && ((overallStatus = context.getVariable(SD.OVERALL_STATUS_VARIABLE).getValue()).equals(SD.CONTINUE) || overallStatus.equals(SD.SAME_PROBLEM_DETECTED) || overallStatus.equals(SD.NEW_PROBLEM_DETECTED))) {
                Trace.trace(TRACE_MASKT, "PIDriveExchangeAndVerify.fire partial FRU group exchanged - overriding overall status (" + overallStatus + ") with SWITCH_FRUS");
                context.getVariable(SD.OVERALL_STATUS_VARIABLE).setValue(SD.SWITCH_FRUS);
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-! PIDriveExchangeAndVerify.fire, exception caught: " + e);
            Trace.trace(TRACE_MASKT, e);
            if (e instanceof EffectorException) {
                throw (EffectorException)e;
            }
            throw new EffectorException(e);
        }
        Trace.trace(TRACE_MASKT, "<- PIDriveExchangeAndVerify.fire");
    }
}

